#include <stdio.h>
#include <string.h>
#include <windows.h>

double const PI = 3.14159265358979323846;

HINSTANCE dllInstance;

#define MAX_BUFFER_LENGTH		256			// in number of samples

class COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack();
	virtual bool __cdecl IsTagged();
	virtual bool __cdecl IsStreamed();
	virtual bool __cdecl IsRequiresWaveout();
	virtual bool __cdecl IsLossyCompression();

	virtual bool __cdecl IsSampleRateChangeable();
	virtual bool __cdecl SampleRateChanged(int samplerate);
	virtual bool __cdecl IsBitRateChangeable();
	virtual bool __cdecl BitRateChanged(int bitrate);

	virtual bool __cdecl SupportsSampleRate(int samplerate);
	virtual bool __cdecl SupportsBitRate(int bitrate);

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name);
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata);

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples);

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain);
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain);

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id);
	virtual char * __cdecl RecordersWebSiteURL();

	virtual int __cdecl RecorderVersion();

	virtual void GetRecorderExtensionsClass(int param, void **exmodule);
};

class rec;

#define EXPORTTHING \
extern "C" { \
__declspec(dllexport) COOERecorder * __cdecl CreateRecorder() { return new rec; } \
__declspec(dllexport) char * __cdecl RecInfo() { return RECORDERNAME; } \
}

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: { dllInstance = (HINSTANCE) hModule; } break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
